/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.experiment.Experiment;
import weka.experiment.PropertyNode;
import weka.experiment.RemoteExperiment;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyPanel;
import weka.gui.experiment.DatasetListPanel;
import weka.gui.experiment.DistributeExperimentPanel;
import weka.gui.experiment.GeneratorPropertyIteratorPanel;
import weka.gui.experiment.RunNumberPanel;

public class SetupPanel
extends JPanel {
    private static final long serialVersionUID = 6552671886903170033L;
    protected Experiment m_Exp;
    protected JButton m_OpenBut = new JButton("Open...");
    protected JButton m_SaveBut = new JButton("Save...");
    protected JButton m_NewBut = new JButton("New");
    protected FileFilter m_ExpFilter = new ExtensionFileFilter(Experiment.FILE_EXTENSION, "Experiment configuration files (*" + Experiment.FILE_EXTENSION + ")");
    protected FileFilter m_KOMLFilter = new ExtensionFileFilter(".koml", "Experiment configuration files (*.koml)");
    protected FileFilter m_XMLFilter = new ExtensionFileFilter(".xml", "Experiment configuration files (*.xml)");
    protected JFileChooser m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected GenericObjectEditor m_RPEditor = new GenericObjectEditor();
    protected PropertyPanel m_RPEditorPanel = new PropertyPanel(this.m_RPEditor);
    protected GenericObjectEditor m_RLEditor = new GenericObjectEditor();
    protected PropertyPanel m_RLEditorPanel = new PropertyPanel(this.m_RLEditor);
    protected GeneratorPropertyIteratorPanel m_GeneratorPropertyPanel = new GeneratorPropertyIteratorPanel();
    protected RunNumberPanel m_RunNumberPanel = new RunNumberPanel();
    protected DistributeExperimentPanel m_DistributeExperimentPanel = new DistributeExperimentPanel();
    protected DatasetListPanel m_DatasetListPanel = new DatasetListPanel();
    protected JButton m_NotesButton = new JButton("Notes");
    protected JFrame m_NotesFrame = new JFrame("Notes");
    protected JTextArea m_NotesText = new JTextArea(null, 10, 0);
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected JRadioButton m_advanceDataSetFirst = new JRadioButton("Data sets first");
    protected JRadioButton m_advanceIteratorFirst = new JRadioButton("Custom generator first");
    ActionListener m_RadioListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SetupPanel.this.updateRadioLinks();
        }
    };

    static {
        GenericObjectEditor.registerEditors();
    }

    public SetupPanel(Experiment exp) {
        this();
        this.setExperiment(exp);
    }

    public SetupPanel() {
        this.m_DistributeExperimentPanel.addCheckBoxActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SetupPanel.this.m_DistributeExperimentPanel.distributedExperimentSelected()) {
                    if (!(SetupPanel.this.m_Exp instanceof RemoteExperiment)) {
                        try {
                            RemoteExperiment re = new RemoteExperiment(SetupPanel.this.m_Exp);
                            SetupPanel.this.setExperiment(re);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                } else if (SetupPanel.this.m_Exp instanceof RemoteExperiment) {
                    SetupPanel.this.setExperiment(((RemoteExperiment)SetupPanel.this.m_Exp).getBaseExperiment());
                }
            }
        });
        this.m_NewBut.setMnemonic('N');
        this.m_NewBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetupPanel.this.setExperiment(new Experiment());
            }
        });
        this.m_SaveBut.setMnemonic('S');
        this.m_SaveBut.setEnabled(false);
        this.m_SaveBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetupPanel.this.saveExperiment();
            }
        });
        this.m_OpenBut.setMnemonic('O');
        this.m_OpenBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetupPanel.this.openExperiment();
            }
        });
        this.m_FileChooser.addChoosableFileFilter(this.m_ExpFilter);
        if (KOML.isPresent()) {
            this.m_FileChooser.addChoosableFileFilter(this.m_KOMLFilter);
        }
        this.m_FileChooser.addChoosableFileFilter(this.m_XMLFilter);
        this.m_FileChooser.setFileFilter(this.m_ExpFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_GeneratorPropertyPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetupPanel.this.updateRadioLinks();
            }
        });
        this.m_RPEditor.setClassType(ResultProducer.class);
        this.m_RPEditor.setEnabled(false);
        this.m_RPEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SetupPanel.this.m_Exp.setResultProducer((ResultProducer)SetupPanel.this.m_RPEditor.getValue());
                SetupPanel.this.m_Exp.setUsePropertyIterator(false);
                SetupPanel.this.m_Exp.setPropertyArray(null);
                SetupPanel.this.m_Exp.setPropertyPath(null);
                SetupPanel.this.m_GeneratorPropertyPanel.setExperiment(SetupPanel.this.m_Exp);
                SetupPanel.this.repaint();
            }
        });
        this.m_RLEditor.setClassType(ResultListener.class);
        this.m_RLEditor.setEnabled(false);
        this.m_RLEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SetupPanel.this.m_Exp.setResultListener((ResultListener)SetupPanel.this.m_RLEditor.getValue());
                SetupPanel.this.m_Support.firePropertyChange("", null, null);
                SetupPanel.this.repaint();
            }
        });
        this.m_NotesFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SetupPanel.this.m_NotesButton.setEnabled(true);
            }
        });
        this.m_NotesFrame.getContentPane().add(new JScrollPane(this.m_NotesText));
        this.m_NotesFrame.setSize(600, 400);
        this.m_NotesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetupPanel.this.m_NotesButton.setEnabled(false);
                SetupPanel.this.m_NotesFrame.setVisible(true);
            }
        });
        this.m_NotesButton.setEnabled(false);
        this.m_NotesText.setEditable(true);
        this.m_NotesText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SetupPanel.this.m_Exp.setNotes(SetupPanel.this.m_NotesText.getText());
            }
        });
        this.m_NotesText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SetupPanel.this.m_Exp.setNotes(SetupPanel.this.m_NotesText.getText());
            }
        });
        JPanel buttons = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        buttons.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        buttons.setLayout(gb);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        buttons.add((Component)this.m_OpenBut, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        buttons.add((Component)this.m_SaveBut, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        buttons.add((Component)this.m_NewBut, constraints);
        JPanel src = new JPanel();
        src.setLayout(new BorderLayout());
        src.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Result generator"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        src.add((Component)this.m_RPEditorPanel, "North");
        this.m_RPEditorPanel.setEnabled(false);
        JPanel dest = new JPanel();
        dest.setLayout(new BorderLayout());
        dest.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Destination"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        dest.add((Component)this.m_RLEditorPanel, "North");
        this.m_RLEditorPanel.setEnabled(false);
        this.m_advanceDataSetFirst.setEnabled(false);
        this.m_advanceIteratorFirst.setEnabled(false);
        this.m_advanceDataSetFirst.setToolTipText("Advance data set before custom generator");
        this.m_advanceIteratorFirst.setToolTipText("Advance custom generator before data set");
        this.m_advanceDataSetFirst.setSelected(true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_advanceDataSetFirst);
        bg.add(this.m_advanceIteratorFirst);
        this.m_advanceDataSetFirst.addActionListener(this.m_RadioListener);
        this.m_advanceIteratorFirst.addActionListener(this.m_RadioListener);
        JPanel radioButs = new JPanel();
        radioButs.setBorder(BorderFactory.createTitledBorder("Iteration control"));
        radioButs.setLayout(new GridLayout(1, 2));
        radioButs.add(this.m_advanceDataSetFirst);
        radioButs.add(this.m_advanceIteratorFirst);
        JPanel simpleIterators = new JPanel();
        simpleIterators.setLayout(new BorderLayout());
        JPanel tmp = new JPanel();
        tmp.setLayout(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        tmp.add((Component)this.m_RunNumberPanel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        tmp.add((Component)this.m_DistributeExperimentPanel, constraints);
        JPanel tmp2 = new JPanel();
        tmp2.setLayout(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(0, 2, 0, 2);
        tmp2.add((Component)tmp, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        tmp2.add((Component)radioButs, constraints);
        simpleIterators.add((Component)tmp2, "North");
        simpleIterators.add((Component)this.m_DatasetListPanel, "Center");
        JPanel iterators = new JPanel();
        iterators.setLayout(new GridLayout(1, 2));
        iterators.add(simpleIterators);
        iterators.add(this.m_GeneratorPropertyPanel);
        JPanel top = new JPanel();
        top.setLayout(new GridLayout(2, 1));
        top.add(dest);
        top.add(src);
        JPanel notes = new JPanel();
        notes.setLayout(new BorderLayout());
        notes.add((Component)this.m_NotesButton, "Center");
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.add((Component)iterators, "Center");
        p2.add((Component)notes, "South");
        JPanel p3 = new JPanel();
        p3.setLayout(new BorderLayout());
        p3.add((Component)buttons, "North");
        p3.add((Component)top, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)p3, "North");
        this.add((Component)p2, "Center");
    }

    protected void removeNotesFrame() {
        this.m_NotesFrame.setVisible(false);
    }

    public void setExperiment(Experiment exp) {
        boolean iteratorOn = exp.getUsePropertyIterator();
        Object propArray = exp.getPropertyArray();
        PropertyNode[] propPath = exp.getPropertyPath();
        this.m_Exp = exp;
        this.m_SaveBut.setEnabled(true);
        this.m_RPEditor.setValue(this.m_Exp.getResultProducer());
        this.m_RPEditor.setEnabled(true);
        this.m_RPEditorPanel.setEnabled(true);
        this.m_RPEditorPanel.repaint();
        this.m_RLEditor.setValue(this.m_Exp.getResultListener());
        this.m_RLEditor.setEnabled(true);
        this.m_RLEditorPanel.setEnabled(true);
        this.m_RLEditorPanel.repaint();
        this.m_NotesText.setText(exp.getNotes());
        this.m_NotesButton.setEnabled(true);
        this.m_advanceDataSetFirst.setSelected(this.m_Exp.getAdvanceDataSetFirst());
        this.m_advanceIteratorFirst.setSelected(!this.m_Exp.getAdvanceDataSetFirst());
        this.m_advanceDataSetFirst.setEnabled(true);
        this.m_advanceIteratorFirst.setEnabled(true);
        exp.setPropertyPath(propPath);
        exp.setPropertyArray(propArray);
        exp.setUsePropertyIterator(iteratorOn);
        this.m_GeneratorPropertyPanel.setExperiment(this.m_Exp);
        this.m_RunNumberPanel.setExperiment(this.m_Exp);
        this.m_DatasetListPanel.setExperiment(this.m_Exp);
        this.m_DistributeExperimentPanel.setExperiment(this.m_Exp);
        this.m_Support.firePropertyChange("", null, null);
    }

    public Experiment getExperiment() {
        return this.m_Exp;
    }

    private void openExperiment() {
        int returnVal = this.m_FileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File expFile = this.m_FileChooser.getSelectedFile();
        if (this.m_FileChooser.getFileFilter() == this.m_ExpFilter) {
            if (!expFile.getName().toLowerCase().endsWith(Experiment.FILE_EXTENSION)) {
                expFile = new File(expFile.getParent(), String.valueOf(expFile.getName()) + Experiment.FILE_EXTENSION);
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
            if (!expFile.getName().toLowerCase().endsWith(".koml")) {
                expFile = new File(expFile.getParent(), String.valueOf(expFile.getName()) + ".koml");
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter && !expFile.getName().toLowerCase().endsWith(".xml")) {
            expFile = new File(expFile.getParent(), String.valueOf(expFile.getName()) + ".xml");
        }
        try {
            Experiment exp = Experiment.read(expFile.getAbsolutePath());
            this.setExperiment(exp);
            System.err.println("Opened experiment:\n" + this.m_Exp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Couldn't open experiment file:\n" + expFile + "\nReason:\n" + ex.getMessage(), "Open Experiment", 0);
        }
    }

    private void saveExperiment() {
        int returnVal = this.m_FileChooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        File expFile = this.m_FileChooser.getSelectedFile();
        if (this.m_FileChooser.getFileFilter() == this.m_ExpFilter) {
            if (!expFile.getName().toLowerCase().endsWith(Experiment.FILE_EXTENSION)) {
                expFile = new File(expFile.getParent(), String.valueOf(expFile.getName()) + Experiment.FILE_EXTENSION);
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
            if (!expFile.getName().toLowerCase().endsWith(".koml")) {
                expFile = new File(expFile.getParent(), String.valueOf(expFile.getName()) + ".koml");
            }
        } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter && !expFile.getName().toLowerCase().endsWith(".xml")) {
            expFile = new File(expFile.getParent(), String.valueOf(expFile.getName()) + ".xml");
        }
        try {
            Experiment.write(expFile.getAbsolutePath(), this.m_Exp);
            System.err.println("Saved experiment:\n" + this.m_Exp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Couldn't save experiment file:\n" + expFile + "\nReason:\n" + ex.getMessage(), "Save Experiment", 0);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    private void updateRadioLinks() {
        this.m_advanceDataSetFirst.setEnabled(this.m_GeneratorPropertyPanel.getEditorActive());
        this.m_advanceIteratorFirst.setEnabled(this.m_GeneratorPropertyPanel.getEditorActive());
        if (this.m_Exp != null) {
            if (!this.m_GeneratorPropertyPanel.getEditorActive()) {
                this.m_Exp.setAdvanceDataSetFirst(true);
            } else {
                this.m_Exp.setAdvanceDataSetFirst(this.m_advanceDataSetFirst.isSelected());
            }
        }
    }

    public static void main(String[] args) {
        try {
            boolean readExp = Utils.getFlag('l', args);
            final boolean writeExp = Utils.getFlag('s', args);
            final String expFile = Utils.getOption('f', args);
            if ((readExp || writeExp) && expFile.length() == 0) {
                throw new Exception("A filename must be given with the -f option");
            }
            Experiment exp = null;
            if (readExp) {
                FileInputStream fi = new FileInputStream(expFile);
                ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(fi));
                exp = (Experiment)oi.readObject();
                oi.close();
            } else {
                exp = new Experiment();
            }
            System.err.println("Initial Experiment:\n" + exp.toString());
            final JFrame jf = new JFrame("Weka Experiment Setup");
            jf.getContentPane().setLayout(new BorderLayout());
            SetupPanel sp = new SetupPanel();
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.err.println("\nFinal Experiment:\n" + SetupPanel.this.m_Exp.toString());
                    if (writeExp) {
                        try {
                            FileOutputStream fo = new FileOutputStream(expFile);
                            ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(fo));
                            oo.writeObject(SetupPanel.this.m_Exp);
                            oo.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            System.err.println("Couldn't write experiment to: " + expFile + '\n' + ex.getMessage());
                        }
                    }
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            System.err.println("Short nap");
            Thread.currentThread();
            Thread.sleep(3000L);
            System.err.println("Done");
            sp.setExperiment(exp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

